﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.IO;
using UTILS;
using System.Text;

namespace LFSLapper
{
    partial class LFSClient
    {
        public void CreateFile(GLScript.unionVal val, infoPlayer currInfoPlayer, string function, string FileName, string Folder, string FileExistTodo)
        {
            string Path = @"" + Folder + "\\" + FileName + ".txt";
            string BackUpPath = @"" + Folder + "\\" + FileName + "_Backup.txt";

            try
            {
                FileInfo File = new FileInfo(Path);
                if (File.Exists)
                {
                    switch (FileExistTodo)
                    {
                        case "0": //do nothing
                            {

                            }
                            break;
                        case "1": //overwrite
                            {
                                File.Delete(); //Delete current file
                                File.Create().Close(); //Create new file
                            }
                            break;
                        case "2": //overwrite + create backup
                            {
                                try
                                {
                                    // Move file with a new name within the same directory.
                                    File.MoveTo(BackUpPath);
                                    //Create new file.
                                    FileInfo NewFile = new FileInfo(Path);
                                    NewFile.Create().Close();
                                }
                                catch
                                {
                                    throw new GLScript.GLApp.GLScriptException("ERROR on Function: " + function + ", backup file exist , cannot create new backup file!");
                                }
                            }
                            break;
                    }
                }
                else
                {
                    File.Create().Close();
                }
            }
            catch
            {
                throw new GLScript.GLApp.GLScriptException("ERROR on Function: " + function + ", incorrect number of parameters or parameters are wrong. ");
            }
        }

        public void DeleteFile(GLScript.unionVal val, infoPlayer currInfoPlayer, string function, string FileName, string Folder, string CopyFolder, string Extension)
        {
            //Set Path and Path to copy to.
            string Path = @"" + Folder + "\\" + FileName + "" + Extension;
            string CopyPath = @"" + CopyFolder + "\\" + FileName + "" + Extension;

            try
            {
                    FileInfo File = new FileInfo(Path);
                    if (CopyFolder != "")
                    {
                        FileInfo CopyFile = new FileInfo(CopyPath);
                        CopyFile.Delete();
                        File.CopyTo(CopyPath);
                    }
                    //if orginal file exist
                    if (File.Exists)
                    {
                        File.Delete();
                    }
                    else
                    {
                        throw new GLScript.GLApp.GLScriptException("^3WARNING: ^8on Function: " + function + ", File doesnt exist: " + Path + "");
                    }
            }
            catch
            {
            }
        }

        public void EditFile(GLScript.unionVal val, infoPlayer currInfoPlayer, string function, string FileName, string Folder, string Text, string LineToEdit, string Extension)
        {
            string Path = @"" + Folder + "\\" + FileName + "" + Extension;
            try
            {
                if (File.Exists(Path))
                {
                    //Convert string to int.
                    int EditLine = Int32.Parse(LineToEdit);

                    //Read file.
                    if (EditLine == -1)
                    {
                        try
                        {
                            //enable AppendText, opens file 
                            TextWriter WriteFile = new StreamWriter(Path, true);
                            WriteFile.WriteLine(Text);
                            WriteFile.Close(); //close file after writing
                        }
                        catch (Exception e)
                        {
                            throw new GLScript.GLApp.GLScriptException(e.Message);
                        }
                    }
                    else
                    {
                        try
                        {
                            /*
                            // Store all lines in a array
                            // When Array the correct line it will add the edited text.
                            // Write all lines back to current file include the edited text.
                            */
                            string[] ArrayOfLines = System.IO.File.ReadAllLines(Path);
                            if (ArrayOfLines.Length >= 1)
                            {
                                if ((EditLine - 1) < ArrayOfLines.Length)
                                {
                                    ArrayOfLines[EditLine - 1] = Text;

                                    StreamWriter WriteFile = new StreamWriter(Path);
                                    for (int x = 0; x < ArrayOfLines.Length; x++)
                                    {
                                        Console.WriteLine(x);
                                        WriteFile.WriteLine(ArrayOfLines[x]);

                                    }
                                    //close the file after writing.
                                    WriteFile.Close();
                                }
                                else
                                {
                                    throw new GLScript.GLApp.GLScriptException("ERROR on Function: '" + function + "', File doesnt contain that many lines [" + EditLine + "/" + ArrayOfLines.Length + "]");
                                }
                            }
                            else
                            {
                                throw new GLScript.GLApp.GLScriptException("ERROR on Function: '" + function + "', File is empty: [" + ArrayOfLines.Length + "] lines detected, you cant edit any lines.");
                            }
                        }
                        catch (Exception e)
                        {
                            throw new GLScript.GLApp.GLScriptException(e.Message);
                        }
                    }
                    //close file after reading/writing to it
                }
                else
                {
                    throw new GLScript.GLApp.GLScriptException("ERROR on Function: '" + function + "', File doesnt exist");
                }
            }
            catch (Exception e)
            {
                throw new GLScript.GLApp.GLScriptException(e.Message);
            }
        }
    }
}
